public delegate bool IterSelectDelegate(object o);
	
public class IterSelect: IterIsolate, IEnumerable
{
  internal class IterSelectEnumerator: IterIsolateEnumerator, IEnumerator
  {
    internal IterSelectEnumerator(IEnumerator enumerator, 
                             IterSelectDelegate selector): base(enumerator)
    {
      for (int index = items.Count - 1; index >= 0; index--)
      {
        if (!selector(items[index]))
          items.RemoveAt(index);
      }

      currentItem = items.Count;
    }

    public new void Reset()
    {
      currentItem = items.Count;
    }

    public new bool MoveNext()
    {
      currentItem--;
      if (currentItem < 0)
        return false;

      return true;
    }
  }

  public IterSelect(IEnumerable enumerable, IterSelectDelegate selector): base(enumerable)
  {
    this.selector = selector;
  }

  public new IEnumerator GetEnumerator()
  {
    return new IterSelectEnumerator(enumerable.GetEnumerator(), selector);
  }

  IterSelectDelegate selector;
}
